package app.firezone.synk.network.Activities;

import static android.content.ContentValues.TAG;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityEarnMoneyBinding;
import app.firezone.synk.network.model.User;

import java.util.HashMap;

public class EarnMoneyActivity extends AppCompatActivity {


    ActivityEarnMoneyBinding binding;


    DatabaseReference reference;

    int duration = 2000;

    FirebaseDatabase database;

    boolean doubleTab = false;
    FirebaseAuth auth;
    FirebaseUser user;

    long coinsAvail;

    View view;
    private RewardedAd mRewardedAd;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityEarnMoneyBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());
        binding.backArrow.setOnClickListener(v -> finish());

        database =  FirebaseDatabase.getInstance();
        auth = FirebaseAuth.getInstance();
        user = auth.getCurrentUser();
        reference = FirebaseDatabase.getInstance().getReference().child("Users").child(user.getUid());


        reference.addValueEventListener(new ValueEventListener() {
            @Override
            public void onDataChange(@NonNull DataSnapshot snapshot) {

                User model = snapshot.getValue(User.class);

                long totalCoin = model.getDepoBalance()+ model.getWinBalance() + model.getBonusBalance();

                binding.availBalance.setText(String.valueOf("₹"+ totalCoin));

                coinsAvail = model.getBonusBalance();

            }

            @Override
            public void onCancelled(@NonNull DatabaseError error) {

                Toast.makeText(EarnMoneyActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();

            }
        });

        MobileAds.initialize(this, new OnInitializationCompleteListener() {
            @Override
            public void onInitializationComplete(@NonNull InitializationStatus initializationStatus) {
            }
        });

        binding.watchVideo.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                showAds();
            }
        });


        binding.offerTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(EarnMoneyActivity.this, CominSoonActivity.class));
            }
        });

        binding.offerTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(EarnMoneyActivity.this, CominSoonActivity.class));
            }
        });


        binding.spinTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(EarnMoneyActivity.this, CominSoonActivity.class));
            }
        });


        binding.surveyTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(EarnMoneyActivity.this, CominSoonActivity.class));
            }
        });


        binding.scratchTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(EarnMoneyActivity.this, CominSoonActivity.class));
            }
        });

        binding.referTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(EarnMoneyActivity.this, ReferActivity.class));
            }
        });


        binding.redeemTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(EarnMoneyActivity.this, RedeemActivity.class));
            }
        });


    }

    private void showAds() {

        AdRequest adRequest = new AdRequest.Builder().build();

        RewardedAd.load(this, getString(R.string.admob_rewarded_id),
                adRequest, new RewardedAdLoadCallback() {
                    @Override
                    public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                        mRewardedAd = null;

                        binding.watchVideo.setEnabled(false);

                        Toast.makeText(EarnMoneyActivity.this, "failed to load", Toast.LENGTH_SHORT).show();

                    }

                    @Override
                    public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                        mRewardedAd = rewardedAd;

                        binding.watchVideo.setEnabled(true);

                    }
                });


        if (mRewardedAd != null) {
            Activity activityContext = EarnMoneyActivity.this;
            mRewardedAd.show(activityContext, new OnUserEarnedRewardListener() {
                @Override
                public void onUserEarnedReward(@NonNull RewardItem rewardItem) {

                    //  Log.d(TAG, "The user earned the reward.");
                    int rewardAmount = rewardItem.getAmount();
                    String rewardType = rewardItem.getType();

                    updateDataFirebase();
                }
            });
        } else {
            Log.d(TAG, "The rewarded ad wasn't ready yet.");
        }


    }



    private void updateDataFirebase() {

        long currentCoins = coinsAvail;
        long updatedCoin = currentCoins + 5;

        HashMap<String, Object> map = new HashMap<>();
        map.put("bonusBalance",updatedCoin);

        reference.updateChildren(map)
                .addOnCompleteListener(new OnCompleteListener<Void>() {
                    @Override
                    public void onComplete(@NonNull Task<Void> task) {

                        if (task.isSuccessful()){

                            Toast.makeText(EarnMoneyActivity.this, "coins added", Toast.LENGTH_SHORT).show();

                        }
                        else {

                            Toast.makeText(EarnMoneyActivity.this, "coins not added", Toast.LENGTH_SHORT).show();
                        }
                    }
                });

    }




    private void gotoUrl(String s) {
        Uri uri= Uri.parse(s);
        startActivity(new Intent(Intent.ACTION_VIEW,uri));
    }

}